function defformCopy(id) {
    var text = document.getElementById('shortcode-' + id).innerText;

    if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(text).then(function() {
            defformShowCopyMsg(id);
        }).catch(function() {
            defformFallbackCopy(text, id);
        });
    } else {
        defformFallbackCopy(text, id);
    }
}

function defformFallbackCopy(text, id) {
    var textarea = document.createElement('textarea');
    textarea.value = text;
    document.body.appendChild(textarea);
    textarea.select();
    document.execCommand('copy');
    document.body.removeChild(textarea);
    defformShowCopyMsg(id);
}

function defformShowCopyMsg(id) {
    var msg = document.getElementById('copy-msg-' + id);
    msg.style.display = 'inline';
    setTimeout(function() {
        msg.style.display = 'none';
    }, 2000);
}