<?php if (!defined('ABSPATH')) exit; ?>

<div class="wrap">
    <h1>フォームを追加</h1>

    <a href="<?php echo admin_url('admin.php?page=defform-dashboard-forms'); ?>" class="page-title-action">
        ← 一覧に戻る
    </a>

    <div class="card" style="max-width: 600px; padding: 20px; margin-top: 20px;">
        <form method="post" enctype="multipart/form-data">
            <?php wp_nonce_field('defform_form_action', 'defform_nonce'); ?>
            <input type="hidden" name="defform_action" value="add_form">

            <table class="form-table">
                <tr>
                    <th><label for="form_name">フォーム名 <span style="color:red;">*</span></label></th>
                    <td>
                        <input type="text"
                               id="form_name"
                               name="form_name"
                               class="regular-text"
                               required
                               placeholder="例：お問い合わせフォーム">
                    </td>
                </tr>
                <tr>
                    <th><label for="defform_id">ID <span style="color:red;">*</span></label></th>
                    <td>
                        <input type="text"
                               id="defform_id"
                               name="defform_id"
                               class="regular-text"
                               required
                               pattern="[a-zA-Z0-9_-]+"
                               placeholder="例：contact-form">
                        <p class="description">div id="こちらに入ります" 英数字のみ</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="form_url">フォームURL（任意）</label></th>
                    <td>
                        <input type="url"
                               id="form_url"
                               name="form_url"
                               class="regular-text"
                               placeholder="https://dashboard.defform.com/forms/...">
                        <p class="description">Defform管理画面のフォームURL</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="js_file">JSファイル <span style="color:red;">*</span></label></th>
                    <td>
                        <input type="file"
                               id="js_file"
                               name="js_file"
                               accept=".js"
                               required>
                        <p class="description">Defformでビルドしたembed.jsファイルをアップロード</p>
                    </td>
                </tr>
            </table>

            <p class="submit">
                <input type="submit" class="button button-primary" value="フォームを追加">
            </p>
        </form>
    </div>
</div>