<?php
if (!defined('ABSPATH')) exit;

$id = intval($_GET['id'] ?? 0);
$form = $this->form_manager->get_form($id);

if (!$form) {
    echo '<div class="wrap"><h1>フォームが見つかりません</h1></div>';
    return;
}
?>

<div class="wrap">
    <h1>フォームを編集</h1>

    <a href="<?php echo admin_url('admin.php?page=defform-dashboard-forms'); ?>" class="page-title-action">
        ← 一覧に戻る
    </a>

    <div class="card" style="max-width: 600px; padding: 20px; margin-top: 20px;">
        <form method="post" enctype="multipart/form-data">
            <?php wp_nonce_field('defform_form_action', 'defform_nonce'); ?>
            <input type="hidden" name="defform_action" value="edit_form">
            <input type="hidden" name="form_id" value="<?php echo esc_attr($form->id); ?>">

            <table class="form-table">
                <tr>
                    <th><label for="form_name">フォーム名 <span style="color:red;">*</span></label></th>
                    <td>
                        <input type="text"
                               id="form_name"
                               name="form_name"
                               class="regular-text"
                               required
                               value="<?php echo esc_attr($form->form_name); ?>">
                    </td>
                </tr>
                <tr>
                    <th><label for="defform_id">ID <span style="color:red;">*</span></label></th>
                    <td>
                        <input type="text"
                               id="defform_id"
                               name="defform_id"
                               class="regular-text"
                               required
                               pattern="[a-zA-Z0-9_-]+"
                               value="<?php echo esc_attr($form->defform_id); ?>">
                        <p class="description">div id="こちらに入ります" 英数字のみ</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="form_url">フォームURL（任意）</label></th>
                    <td>
                        <input type="url"
                               id="form_url"
                               name="form_url"
                               class="regular-text"
                               value="<?php echo esc_attr($form->form_url); ?>">
                    </td>
                </tr>
                <tr>
                    <th>現在のJSファイル</th>
                    <td>
                        <?php if (!empty($form->js_file_path)): ?>
                            <code><?php echo esc_html(basename($form->js_file_path)); ?></code>
                            <p class="description">✓ アップロード済み</p>
                        <?php else: ?>
                            <p style="color: red;">未設定</p>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th><label for="js_file">JSファイルを変更</label></th>
                    <td>
                        <input type="file"
                               id="js_file"
                               name="js_file"
                               accept=".js">
                        <p class="description">変更する場合のみ選択してください</p>
                    </td>
                </tr>
            </table>

            <p class="submit">
                <input type="submit" class="button button-primary" value="更新する">
            </p>
        </form>
    </div>
</div>