<?php if (!defined('ABSPATH')) exit; ?>

<div class="wrap">
    <h1>フォーム管理</h1>

    <!-- 追加ボタン -->
    <div style="margin: 20px 0;">
        <a href="<?php echo admin_url('admin.php?page=defform-dashboard-forms&action=add'); ?>"
           class="button button-primary">
            ＋ 新しいフォームを追加
        </a>
    </div>

    <!-- メッセージ -->
    <?php
    $message = get_transient('defform_message');
    $message_type = get_transient('defform_message_type') ?: 'success';
    if ($message):
        delete_transient('defform_message');
        delete_transient('defform_message_type');
    ?>
        <div class="notice notice-<?php echo esc_attr($message_type); ?> is-dismissible">
            <p><?php echo esc_html($message); ?></p>
        </div>
    <?php endif; ?>

    <!-- フォーム一覧 -->
    <?php if (empty($forms)): ?>
        <div class="card" style="padding: 20px;">
            <p>まだフォームが登録されていません。</p>
            <p>「新しいフォームを追加」ボタンからフォームを登録してください。</p>
        </div>
    <?php else: ?>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th style="width: 50px;">No.</th>
                    <th style="width: 120px;">ID</th>
                    <th>フォーム名</th>
                    <th>ショートコード</th>
                    <th>作成日</th>
                    <th style="width: 80px;">状態</th>
                    <th style="width: 250px;">操作</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($forms as $form): ?>
                <tr>
                    <td><?php echo esc_html($form->id); ?></td>
                    <td><code><?php echo esc_html($form->defform_id); ?></code></td>
                    <td><strong><?php echo esc_html($form->form_name); ?></strong></td>
                    <td>
                        <div style="display: inline-flex; align-items: center; gap: 8px;">
                            <code id="shortcode-<?php echo esc_attr($form->id); ?>">[defform id="<?php echo esc_attr($form->id); ?>"]</code>
                            <button type="button"
                                    class="button button-small"
                                    onclick="defformCopy('<?php echo esc_attr($form->id); ?>')"
                                    title="ショートコードをコピー">
                                📋
                            </button>
                            <span id="copy-msg-<?php echo esc_attr($form->id); ?>" style="color:green; display:none; font-size: 12px;">
                                ✓
                            </span>
                        </div>
                    </td>
                    <td><?php echo esc_html($form->created_at); ?></td>
                    <td>
                        <?php if ($form->is_active): ?>
                            <span style="color: green; font-weight: bold;">●有効</span>
                        <?php else: ?>
                            <span style="color: gray;">●無効</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <!-- 編集 -->
                        <a href="<?php echo admin_url('admin.php?page=defform-dashboard-forms&action=edit&id=' . $form->id); ?>"
                           class="button button-small">
                            編集
                        </a>

                        <!-- 有効/無効切り替え -->
                        <form method="post" style="display: inline;">
                            <?php wp_nonce_field('defform_form_action', 'defform_nonce'); ?>
                            <input type="hidden" name="defform_action" value="toggle_form">
                            <input type="hidden" name="form_id" value="<?php echo esc_attr($form->id); ?>">
                            <button type="submit" class="button button-small">
                                <?php echo $form->is_active ? '無効にする' : '有効にする'; ?>
                            </button>
                        </form>

                        <!-- 削除 -->
                        <form method="post" style="display: inline;"
                              onsubmit="return confirm('「<?php echo esc_js($form->form_name); ?>」を削除しますか？');">
                            <?php wp_nonce_field('defform_form_action', 'defform_nonce'); ?>
                            <input type="hidden" name="defform_action" value="delete_form">
                            <input type="hidden" name="form_id" value="<?php echo esc_attr($form->id); ?>">
                            <button type="submit" class="button button-small" style="color: red;">
                                削除
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>